﻿using System;

namespace Q03a
{
    class Program
    {
        // Subprogram to get and validate the month number -------------------------------------------------
        static int display()
        {
            int monthNumber = 0;
            while (monthNumber < 1 || monthNumber > 12)
            {
                Console.WriteLine("Enter the month number [1 to 12]");
                monthNumber = Convert.ToInt32(Console.ReadLine());
            }
            return monthNumber;
        } // End of subprogram display -----------------------------------------------------------------------


        // Subprogram to show the name of the month and the number of days in the month ----------------------
        static void showMonthNameAndDays(int pMonth)
        {
        	// Month number, days in the month and month name
            string[,] monthsAndDays = {
                {"1", "31", "January"},
                {"2", "28", "February"},
                {"3", "31", "March"},
                {"4", "30", "April"},
                {"5", "31", "May"},
                {"6", "31", "June" },
                {"7", "31", "July"},
                {"8", "31", "August"},
                {"9", "31", "September"},
                {"10", "31", "October"},
                {"11", "31", "November"},
                {"12", "31", "December"}};

            int count = 0;
            bool found = false;
           
            while (count < monthsAndDays.Length && found == false)
            {
                if (monthsAndDays[count, 0] == pMonth.ToString())
                {
                    found = true;
                    Console.WriteLine(monthsAndDays[count, 2] + " has " + monthsAndDays[count, 1] + " days");
                    Console.ReadLine();
                }
                count++;
            }
        } // End of subprogram showMonthNameAndDays ------------------------------------------------------------


        // Main program ---------------------------------------------------------------------------------------
        static void Main(string[] args)
        {
            int monthInput = display();
            showMonthNameAndDays(monthInput);
            
        }
        // End of main program
    } // End of class
} // End of namespace